/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于含加减乘除或括号的数学表达式计算
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 陈小荟
 *      时间 : 2020.03.17
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_data_compute */
/************************************************************************************************
* 类型:
*    函数
* 功能:
*    将表达式拆分计算
* 参数:
    @param { Promise<String> } str 表达式字串
* 返回：
*    @return { Promise<String> }
*     "" 参数有误
*     调用加减乘除计算
* 修改:
*   1. 类型 : 创建
*      作者 : 陈小荟
*      时间 : 2020.03.17
*      内容 : 所有代码
************************************************************************************************/
function mc_data_compute(str) {
    if (null === str) {
        return "";
    }

    //转化成字符串
    if ("string" != typeof str) {
        str += "";
    }

    var arr_ch = str.split("");
    /* eslint-disable no-useless-escape */
    var reg_match_check = new RegExp("[0-9\(\)]+");

    // 表达式前后不为数字或括号并且存在小数点情况
    if (!reg_match_check.test(arr_ch[0]) || !reg_match_check.test(arr_ch[arr_ch.length - 1]) || -1 !== str.indexOf(".")) {
        return false;
    }

    var reg_match = /\([^\(\)]+\)/g;
    //匹配括号
    var obj_mult = str.match(reg_match);

    while (null !== obj_mult) {
        var str_content = obj_mult[0] + "";
        var ui_result = mc_simple_eval(str_content.substr(1,str_content.length - 2));

        str = str.replace(obj_mult[0],ui_result);
        obj_mult = str.match(reg_match);
    }
    return mc_simple_eval(str);
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    只有加减乘除表达式的计算
* 参数:
    @param { Promise<String> } str 表达式字串
* 返回：
*    @return { Promise<String> }
*     "Eval"/"" 参数有误
*     结果数值
* 修改:
*   1. 类型 : 创建
*      作者 : 陈小荟
*      时间 : 2020.03.17
*      内容 : 所有代码
************************************************************************************************/
function mc_simple_eval(str) {
    if (null === str) {
        return "";
    }
    //转化成字符串
    if ("string" !== typeof str) {
        str += "";
    }

    //值的数组
    var arr_val = [];
    //符号的数组
    var arr_mark = [];
    var str_tempval = "";
    var arr_ch = str.split("");
    var b_isopen = false;

    for (var i = 0; i < arr_ch.length; i++) {
        if ( "+" === arr_ch[i] || "-" === arr_ch[i] || "*" === arr_ch[i] || "/" === arr_ch[i]) {
            if ("" === str_tempval) {
                // 多符号相连情况
                return false;
            }
            var ui_dv = str_tempval * 1;

            if (b_isopen) {
                var ui_val = arr_val.pop();
                var str_mark = arr_mark.pop();

                ui_dv = mc_simple_twoeval(str_mark, ui_val, ui_dv);
            }

            arr_val.push(ui_dv);
            arr_mark.push(arr_ch[i]);
            str_tempval = "";
            b_isopen = false;

            if ( "*" === arr_ch[i] || "/" === arr_ch[i] ) {
                b_isopen = true;
            }
        } else {
            // 表达式中只存在单边括号
            if ("(" === arr_ch[i] || ")" === arr_ch[i]) {
                return false;
            }
            str_tempval += arr_ch[i] + "";
            //最后一位
            if (i === arr_ch.length - 1) {
                var ui_dvresult = str_tempval * 1;

                if (b_isopen) {
                    var value = arr_val.pop();
                    var str_last_mark = arr_mark.pop();

                    ui_dvresult = mc_simple_twoeval(str_last_mark, value, ui_dvresult);
                }
                arr_val.push(ui_dvresult);
            }
        }
    }
    arr_val.reverse();
    arr_mark.reverse();
    while (1 < arr_val.length) {
        var v1 = arr_val.pop();
        var v2 = arr_val.pop();
        var mark = arr_mark.pop();

        arr_val.push(mc_simple_twoeval(mark, v1, v2));
    }

    if (!isNaN(arr_val[0])) {
        return arr_val[0];
    }
    return false;
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    两个数的加减乘除
* 参数:
    @param { Promise<String> } str_mark 运算符号
    @param { Promise<Number> } ui_value1 计算数值1
    @param { Promise<Number> } ui_value2 计算数值2
* 返回：
*    @return { Promise<Number> }
*     0 参数有误
*     计算结果
* 修改:
*   1. 类型 : 创建
*      作者 : 陈小荟
*      时间 : 2020.03.17
*      内容 : 所有代码
************************************************************************************************/
function mc_simple_twoeval(str_mark,ui_value1,ui_value2) {
    switch (str_mark) {
    case "+":
        return ui_value1 + ui_value2;
    case "-":
        return ui_value1 - ui_value2;
    case "*":
        return ui_value1 * ui_value2;
    case "/":
        return ui_value1 / ui_value2;
    default:
        return 0;
    }
}
